;------------------------------------------------------------------------
; Panasonic 3DO
; FreeDO v1.9
; by chillinwater & djvj
; 1.2
;
; Notes:
; FreeDO saves it's config in your registry at HKEY_CURRENT_USER\Software\FreeDO\FreeDO Emulator
; The emu does not support CLI or a way of launching fullscreen by default. This is all done manually in the script.
; Supported images are iso, cdi, nrg, bin, img. Cues are not supported. Set your extensions appropriately.
; If your bios file is called fz10_rom.bin, rename it to fz10.rom, it should be placed in the same dir as the emu exe.
; On first launch, FreeDO will ask you to point it to the fz10.rom. After you do that, exit the emu and select a game in HS and it should work.
;------------------------------------------------------------------------

;\\\optional blinds\\\\
Gui +AlwaysOnTop -Caption +ToolWindow 
Gui, color, 0
Gui Show, x0 y0 h%A_ScreenHeight% w%A_ScreenWidth%, 
;\\\\\\\\\\\\\\\\\\\\\\

Run, %executable%, %emuPath%
DetectHiddenWindows, on
WinActivate, FreeDO
Sleep, 500
Send, {ALTDOWN}{ALTUP}{UP}{ENTER 2} ; open ISO
Sleep, 500
clipboard=
clipboard=%romPath%%romName%%romExtension%
ClipWait
Sleep, 500 ; increase this if your clipboard is not pasting in
Send, ^v
Sleep,100
Send, {ENTER}
Sleep, 500
Send, {F4} ; fullscreen
Sleep, 500
SendInput, {ALTDOWN}c{ALTUP}{ENTER 2} ; starts CPU
Sleep, 3000
Gui Destroy
Process, WaitClose, %executable%
WinActivate, HyperSpin

ExitApp

CloseProcess:
	WinClose, FreeDO
return